/*
 * Decompiled with CFR 0.152.
 */
package com.voetsjoeba.buddhabrot;

import com.voetsjoeba.buddhabrot.ComplexNumber;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class MandelbrotPanel
extends JPanel {
    private int width;
    private int height;
    private int unitReal;
    private int unitImaginary;
    private int originX;
    private int originY;
    private boolean drawAxis = false;
    private int[][] count;
    private BufferedImage image;

    public MandelbrotPanel(int width, int height) {
        this.width = width;
        this.height = height;
        this.init();
    }

    private void init() {
        this.count = new int[this.height][this.width];
        this.image = new BufferedImage(this.width, this.height, 2);
        this.unitReal = this.height / 3;
        this.unitImaginary = this.width / 2;
        this.originY = 2 * this.height / 3;
        this.originX = this.unitImaginary;
        Graphics imageGraphics = this.image.getGraphics();
        imageGraphics.setColor(Color.BLACK);
        imageGraphics.fillRect(0, 0, this.width, this.height);
        this.setPreferredSize(new Dimension(this.width, this.height));
        this.addMouseListener(new MandelbrotPanelMouseListener());
        this.toggleAxis();
    }

    protected void toggleAxis() {
        this.drawAxis = !this.drawAxis;
        this.repaint();
    }

    protected ComplexNumber pixelToComplexNumber(int x, int y) {
        double real = ((double)y - (double)this.originY) / (double)this.unitReal;
        double im = ((double)x - (double)this.originX) / (double)this.unitImaginary;
        return new ComplexNumber(real, im);
    }

    protected Point complexNumberToPixel(ComplexNumber c) {
        int x = (int)Math.round((double)this.originX + c.getImaginary() * (double)this.unitImaginary);
        int y = (int)Math.round((double)this.originY + c.getReal() * (double)this.unitReal);
        x = Math.max(0, Math.min(this.width - 1, x));
        y = Math.max(0, Math.min(this.height - 1, y));
        return new Point(x, y);
    }

    protected void iteratePixel(int x, int y) {
        long iterations;
        ComplexNumber c = this.pixelToComplexNumber(x, y);
        ComplexNumber z = new ComplexNumber(0.0, 0.0);
        long maxIterations = 1000L;
        for (iterations = 0L; z.getReal() * z.getReal() + z.getImaginary() * z.getImaginary() < 4.0 && iterations < maxIterations; ++iterations) {
            double newReal = z.getReal() * z.getReal() - z.getImaginary() * z.getImaginary() + c.getReal();
            double newImaginary = 2.0 * z.getReal() * z.getImaginary() + c.getImaginary();
            z.setReal(newReal);
            z.setImaginary(newImaginary);
        }
        if (iterations == maxIterations) {
            this.image.setRGB(x, y, -1);
        } else {
            this.image.setRGB(x, y, -14666940);
        }
        this.repaint();
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawImage(this.image, 0, 0, null);
        if (this.drawAxis) {
            g.setColor(Color.GRAY);
            g.drawLine(0, this.originY, this.width, this.originY);
            g.drawLine(this.originX, 0, this.originX, this.height);
        }
    }

    private class MandelbrotPanelMouseListener
    extends MouseAdapter {
        private MandelbrotPanelMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            Runnable r = new Runnable(){

                public void run() {
                    for (int i = 0; i < MandelbrotPanel.this.height; ++i) {
                        for (int j = 0; j < MandelbrotPanel.this.width; ++j) {
                            MandelbrotPanel.this.iteratePixel(j, i);
                        }
                    }
                }
            };
            new Thread(r).start();
        }
    }
}

