/*
 * Decompiled with CFR 0.152.
 */
package com.voetsjoeba.buddhabrot;

import com.voetsjoeba.buddhabrot.ComplexNumber;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.Random;
import javax.swing.JPanel;

public class ComplexPlanePanel
extends JPanel {
    private int width;
    private int height;
    private int unitReal;
    private int unitImaginary;
    private int originX;
    private int originY;
    private boolean drawAxis = false;
    protected static final Random random = new Random();
    protected BufferedImage image;

    public ComplexPlanePanel(int width, int height) {
        this.width = width;
        this.height = height;
        this.init();
    }

    protected void init() {
        this.image = new BufferedImage(this.width, this.height, 2);
        this.unitReal = this.height / 3;
        this.unitImaginary = this.width / 2;
        this.originY = 2 * this.height / 3;
        this.originX = this.unitImaginary;
        Graphics imageGraphics = this.image.getGraphics();
        imageGraphics.setColor(Color.BLACK);
        imageGraphics.fillRect(0, 0, this.width, this.height);
        this.setPreferredSize(new Dimension(this.width, this.height));
    }

    protected void toggleAxis() {
        this.setDrawAxis(!this.drawAxis);
    }

    public boolean getDrawAxis() {
        return this.drawAxis;
    }

    public void setDrawAxis(boolean drawAxis) {
        if (drawAxis != this.drawAxis) {
            this.drawAxis = drawAxis;
            this.repaint();
        }
    }

    protected ComplexNumber pixelToComplexNumber(int x, int y) {
        double real = ((double)y - (double)this.originY) / (double)this.unitReal;
        double im = ((double)x - (double)this.originX) / (double)this.unitImaginary;
        return new ComplexNumber(real, im);
    }

    protected Point complexNumberToPixel(ComplexNumber c) {
        int x = (int)Math.round((double)this.originX + c.getImaginary() * (double)this.unitImaginary);
        int y = (int)Math.round((double)this.originY + c.getReal() * (double)this.unitReal);
        x = Math.max(0, Math.min(this.width - 1, x));
        y = Math.max(0, Math.min(this.height - 1, y));
        return new Point(x, y);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawImage(this.image, 0, 0, null);
        if (this.drawAxis) {
            g.setColor(Color.GRAY);
            g.drawLine(0, this.originY, this.width, this.originY);
            g.drawLine(this.originX, 0, this.originX, this.height);
        }
    }
}

