/*
 * Decompiled with CFR 0.152.
 */
package com.voetsjoeba.buddhabrot;

public class ComplexNumber {
    private double real;
    private double im;
    public static final ComplexNumber ZERO = new ComplexNumber(0.0, 0.0);
    public static final ComplexNumber ONE = new ComplexNumber(1.0, 0.0);

    public ComplexNumber(ComplexNumber c) {
        this.real = c.getReal();
        this.im = c.getImaginary();
    }

    public ComplexNumber(double real, double im) {
        this.real = real;
        this.im = im;
    }

    public void add(double real, double im) {
        this.real += real;
        this.im += im;
    }

    public void add(int real, int im) {
        this.add((double)real, (double)im);
    }

    public void add(double real) {
        this.real += real;
    }

    public void add(int real) {
        this.add((double)real);
    }

    public void add(ComplexNumber c) {
        this.add(c.getReal(), c.getImaginary());
    }

    public void multiply(ComplexNumber c) {
        this.real = this.real * c.getReal() - this.im * c.getImaginary();
        this.im = this.real * c.getImaginary() + this.im * c.getReal();
    }

    public void multiply(double by) {
        this.real *= by;
        this.im *= by;
    }

    public double getReal() {
        return this.real;
    }

    public double getImaginary() {
        return this.im;
    }

    public void setReal(double real) {
        this.real = real;
    }

    public void setImaginary(double im) {
        this.im = im;
    }

    public String toString() {
        return "(" + this.real + "," + this.im + ")";
    }
}

