/*
 * Decompiled with CFR 0.152.
 */
package com.voetsjoeba.buddhabrot;

public class ColorConversion {
    public static void rgb2hsl(int ir, int ig, int ib, int[] hsl) {
        double fr = (double)ir / 255.0;
        double fg = (double)ig / 255.0;
        double fb = (double)ib / 255.0;
        int imax = Math.max(ir, Math.max(ig, ib));
        int imin = Math.min(ir, Math.min(ig, ib));
        double fmax = (double)imax / 255.0;
        double fmin = (double)imin / 255.0;
        double h = 0.0;
        if (imax != imin) {
            if (imax == ir) {
                h = 60.0 * (fg - fb) / (fmax - fmin) + 360.0;
                h %= 360.0;
            } else if (imax == ig) {
                h = 60.0 * (fb - fr) / (fmax - fmin) + 120.0;
            } else if (imax == ib) {
                h = 60.0 * (fr - fg) / (fmax - fmin) + 240.0;
            }
        }
        double l = fmin + (fmax - fmin) / 2.0;
        double s = 0.0;
        if (imax != imin) {
            s = imax + imin <= 255 ? (fmax - fmin) / (fmax + fmin) : (fmax - fmin) / (2.0 - (fmax + fmin));
        }
        hsl[0] = (int)h;
        hsl[1] = (int)(s * 100.0);
        hsl[2] = (int)(l * 100.0);
    }

    public static void hsl2rgb(int ih, int is, int il, int[] rgb) {
        double fs = (double)is / 100.0;
        double fl = (double)il / 100.0;
        double fh = (double)ih / 360.0;
        double q = 0.0;
        q = il < 50 ? fl * (1.0 + fs) : fl + fs - fl * fs;
        double p = 2.0 * fl - q;
        double tr = fh + 0.3333333333333333;
        double tg = fh;
        double tb = fh - 0.3333333333333333;
        tr = ColorConversion.normalizeTc(tr);
        tg = ColorConversion.normalizeTc(tg);
        tb = ColorConversion.normalizeTc(tb);
        double fr = ColorConversion.calcFc(p, q, tr);
        double fg = ColorConversion.calcFc(p, q, tg);
        double fb = ColorConversion.calcFc(p, q, tb);
        rgb[0] = (int)(fr * 255.0);
        rgb[1] = (int)(fg * 255.0);
        rgb[2] = (int)(fb * 255.0);
    }

    private static double normalizeTc(double tc) {
        double r = tc;
        if (r < 0.0) {
            r += 1.0;
        }
        if (r > 1.0) {
            r -= 1.0;
        }
        return r;
    }

    private static double calcFc(double p, double q, double tc) {
        if (tc < 0.16666666666666666) {
            return p + (q - p) * 6.0 * tc;
        }
        if (tc < 0.5) {
            return q;
        }
        if (tc < 0.6666666666666666) {
            return p + (q - p) * 6.0 * (0.6666666666666666 - tc);
        }
        return p;
    }
}

