/*
 * Decompiled with CFR 0.152.
 */
package com.voetsjoeba.buddhabrot;

import com.voetsjoeba.buddhabrot.ColorConversion;
import com.voetsjoeba.buddhabrot.ComplexNumber;
import com.voetsjoeba.buddhabrot.Mandelbrot;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Random;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class BuddhabrotPanel
extends JPanel {
    private int width;
    private int height;
    private int unitReal;
    private int unitImaginary;
    private int originX;
    private int originY;
    private boolean drawAxis = false;
    private static final Random random = new Random();
    private int[][] count;
    private BufferedImage image;
    private JProgressBar progressBar;
    private double accuracy = 5.0E-4;
    private boolean drawing = false;
    private boolean stopDrawingThread = false;

    public BuddhabrotPanel(int width, int height, int unitReal, int unitImaginary, JProgressBar progressBar) {
        this.width = width;
        this.height = height;
        this.unitReal = unitReal;
        this.unitImaginary = unitImaginary;
        this.progressBar = progressBar;
        this.init();
    }

    private void init() {
        this.originY = 2 * this.height / 3;
        this.originX = this.width / 2;
        this.setPreferredSize(new Dimension(this.width, this.height));
        this.addMouseListener(new BuddhabrotPanelMouseListener());
        this.resetImage();
    }

    private void resetImage() {
        this.count = new int[this.height][this.width];
        this.image = new BufferedImage(this.width, this.height, 2);
        Graphics imageGraphics = this.image.getGraphics();
        imageGraphics.setColor(Color.BLACK);
        imageGraphics.fillRect(0, 0, this.width, this.height);
    }

    protected void toggleAxis() {
        this.drawAxis = !this.drawAxis;
        this.repaint();
    }

    protected ComplexNumber pixelToComplexNumber(int x, int y) {
        double real = ((double)y - (double)this.originY) / (double)this.unitReal;
        double im = ((double)x - (double)this.originX) / (double)this.unitImaginary;
        return new ComplexNumber(real, im);
    }

    protected Point complexNumberToPixel(ComplexNumber c) {
        int x = (int)Math.round((double)this.originX + c.getImaginary() * (double)this.unitImaginary);
        int y = (int)Math.round((double)this.originY + c.getReal() * (double)this.unitReal);
        if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
            return null;
        }
        return new Point(x, y);
    }

    protected void determineMembership(ComplexNumber c) {
        long iterations;
        ComplexNumber z = new ComplexNumber(0.0, 0.0);
        long maxIterations = 1000L;
        for (iterations = 0L; z.getReal() * z.getReal() + z.getImaginary() * z.getImaginary() < 4.0 && iterations < maxIterations; ++iterations) {
            Mandelbrot.mandelbrot(z, c);
        }
        if (iterations != maxIterations) {
            z = new ComplexNumber(0.0, 0.0);
            for (iterations = 0L; z.getReal() * z.getReal() + z.getImaginary() * z.getImaginary() < 4.0 && iterations < maxIterations; ++iterations) {
                Mandelbrot.mandelbrot(z, c);
                Point pixel = this.complexNumberToPixel(z);
                if (pixel == null) continue;
                int[] nArray = this.count[pixel.y];
                int n = pixel.x;
                nArray[n] = nArray[n] + 1;
                this.image.setRGB(pixel.x, pixel.y, this.getPixelColor(pixel.x, pixel.y, this.count[pixel.y][pixel.x]));
            }
            this.repaint();
        }
    }

    protected void traceNonMember(int x, int y) {
    }

    protected int getPixelColor(int x, int y, int count) {
        if (count <= 0) {
            return -65536;
        }
        double fraction = Math.min((double)count / 600.0, 1.0);
        int[] rgb = new int[3];
        ColorConversion.hsl2rgb(250 - (int)(fraction * 80.0), 100 - (int)(fraction * 91.0), (int)(fraction * 100.0), rgb);
        return -16777216 + (rgb[0] << 16) + (rgb[1] << 8) + rgb[2];
    }

    protected void colorBuddha() {
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                this.image.setRGB(j, i, this.getPixelColor(j, i, this.count[i][j]));
            }
        }
        this.repaint();
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawImage(this.image, 0, 0, null);
        if (this.drawAxis) {
            g.setColor(Color.GRAY);
            g.drawLine(0, this.originY, this.width, this.originY);
            g.drawLine(this.originX, 0, this.originX, this.height);
        }
    }

    public void stopDrawing() {
        this.stopDrawingThread = true;
        while (this.drawing) {
            Thread.yield();
        }
    }

    public void draw() {
        this.stopDrawing();
        this.resetImage();
        int totalVerticalSteps = (int)Math.ceil(3.0 / this.accuracy);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(totalVerticalSteps);
        this.progressBar.setValue(this.progressBar.getMinimum());
        Runnable r = new Runnable(){

            public void run() {
                BuddhabrotPanel.this.drawing = true;
                BuddhabrotPanel.this.stopDrawingThread = false;
                double startReal = -((double)BuddhabrotPanel.this.originY / (double)BuddhabrotPanel.this.unitReal);
                double endReal = ((double)BuddhabrotPanel.this.height - (double)BuddhabrotPanel.this.originY) / (double)BuddhabrotPanel.this.unitReal;
                double startIm = -((double)BuddhabrotPanel.this.originX / (double)BuddhabrotPanel.this.unitImaginary);
                double endIm = -startIm;
                for (double r = startReal; r < endReal; r += BuddhabrotPanel.this.accuracy) {
                    for (double i = startIm; i < endIm && !BuddhabrotPanel.this.stopDrawingThread; i += BuddhabrotPanel.this.accuracy) {
                        BuddhabrotPanel.this.determineMembership(new ComplexNumber(r, i));
                    }
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            BuddhabrotPanel.this.progressBar.setValue(BuddhabrotPanel.this.progressBar.getValue() + 1);
                        }
                    });
                    if (BuddhabrotPanel.this.stopDrawingThread) break;
                }
                BuddhabrotPanel.this.drawing = false;
            }
        };
        new Thread(r).start();
    }

    private class BuddhabrotPanelMouseListener
    extends MouseAdapter {
        private BuddhabrotPanelMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            BuddhabrotPanel.this.draw();
        }
    }
}

